/*
 * TagInfoEntry.h
 *
 *  Created on: 23.10.2009
 *      Author: stefan.detter
 */

#ifndef TAGINFOENTRY_H_
#define TAGINFOENTRY_H_

#include "TreeItem.h"

class TagEntry;

class InfoEntry : public TreeItem
{
	Q_OBJECT

public:
	InfoEntry(TreeItem* parent, QString key, QVariant value);
	InfoEntry(TreeItem* parent, QString key, QVariant value, int min, int max, QString text);
	virtual ~InfoEntry();

    void        setDecorator(QString path);

	QString 	key() const;
	QVariant	value() const;
	void 		setValue(QVariant value);

	bool 		hasChild ( QString key );
	void 		addChild ( QString key, QVariant value );
	void 		addChild ( QString key, QVariant value, int min, int max, QString text );
	void		setChildValue ( QString key, QVariant value );

	void 		removeChild ( QString key );
	void 		removeAllChildren ( );


/****************************************************** Display functions */
public:
	virtual DISPLAY_TYPE 	displayType() const;
	virtual TYPE 			itemType() const;
	virtual QVariant 		data(int column, int role) const;
	virtual int 			informationRowCount () const;
	virtual QVariant		information (int row, int column, int role) const;
	virtual QList<int>		informationSpan() const;
public:
	virtual int				progressBarMin() const;
	virtual int				progressBarMax() const;
	virtual QString			progressBarText() const;


private:
    QString         m_decorator;
	QString 		m_key;
	QVariant		m_value;
	DISPLAY_TYPE 	m_type;


	QMap<QString, InfoEntry*>	m_childInfos;

	int				m_progressBarMin;
	int				m_progressBarMax;
	QString			m_progressBarText;
};

#endif /* TAGINFOENTRY_H_ */
